package com.junit5.demo;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import entity.ResultList;
import entity.ShellResult;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.junit.jupiter.api.DynamicTest.dynamicTest;

public class junit5_2_1_DynamicTestDemo {
    @TestFactory
    Collection<DynamicTest> dynamicTestCollection(){
        return Arrays.asList(
                dynamicTest("1st dynamic Test",()-> assertEquals(3,4)),
                dynamicTest("2nd dynamic Test",()-> assertEquals(3,4))
        );
    }


    @Test
    public void entityTest() throws IOException {
        ObjectMapper objectMapper = new ObjectMapper(new YAMLFactory());
        ResultList resultList = objectMapper.readValue(new File("src/main/resources/data/shell_test-result.yaml"),ResultList.class);
    }

    @TestFactory
    Collection<DynamicTest> eunShellResult() throws IOException {
      List<DynamicTest> dynamicTestList = new ArrayList<>();
        ObjectMapper objectMapper = new ObjectMapper(new YAMLFactory());
        ResultList resultList = objectMapper.readValue(new File("src/main/resources/data/shell_test-result.yaml"),ResultList.class);
      for(ShellResult shellResult : resultList.getResultList()){
       // dynamicTestList.add(dynamicTest());
       }
      return null;
    }
    }
